/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm8260;

import ibm.nways.jdm.common.ModelInfo;
import ibm.nways.jdm.common.OctetString;
import ibm.nways.jdm.common.SpecialValue;
import ibm.nways.jdm.modelgen.GenModel;
import ibm.nways.jdm8260.MibInfo;
import ibm.nways.jdm8260.MstDecoder;
import ibm.nways.jdm8260.SstDecoder;
import ibm.nways.jdm8260.SummaryInfoLike;
import ibm.nways.ras.RAS;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;

public final class Jdm8260SummaryInfo
implements SummaryInfoLike {
    private GenModel deviceModel;
    private MibInfo mibInfo;
    public static final int MODEL_8250 = 0;
    public static final int MODEL_8260 = 1;
    public static final int MODEL_8265 = 2;
    public static final int MODEL_UNKNOWN = -1;
    public static final int MIN_DMM_VERSION = 3;
    private int hubModel = -1;
    private int dmmVersion = 3;
    private boolean refreshMST = false;
    private static final String[] sysOidTranslationTable = new String[]{"1.3.6.1.4.1.49.2.3.5", "1.3.6.1.4.1.49.2.3.7", "1.3.6.1.4.1.49.2.3.8", "1.3.6.1.4.1.49.2.3.12", "1.3.6.1.4.1.49.2.3.24", "1.3.6.1.4.1.2.6.33.2.1", "1.3.6.1.4.1.2.6.33.2.3"};
    private static final int[] modelTranslationTable;

    public static int modelFromSysOid(String string) {
        int n = 0;
        while (n < sysOidTranslationTable.length) {
            if (sysOidTranslationTable[n].equals(string)) {
                return modelTranslationTable[n];
            }
            ++n;
        }
        return -1;
    }

    protected void finalize() throws Throwable {
        this.deviceModel = null;
        this.mibInfo = null;
    }

    public void dispose() {
        this.deviceModel = null;
        this.mibInfo = null;
    }

    public final void setMibInfo(MibInfo mibInfo) {
        this.mibInfo = mibInfo;
    }

    public final void setDeviceModel(GenModel genModel) {
        this.deviceModel = genModel;
    }

    public final int getDMMVersion() {
        return this.dmmVersion;
    }

    private final int getDMMVersionFromSysDescr(String string) {
        char c;
        String string2 = "getDMMVersionFromSysDescr";
        int n = string.indexOf("(DMM) ");
        if (n == -1) {
            if (RAS.isEnabled(19, 2)) {
                RAS.trace(19, 2, this, string2, "Tried to parse DMM version of a non DMM -> " + string);
            }
            throw new IllegalArgumentException("Parsing DMM version of a non DMM module: " + string);
        }
        n += 7;
        String string3 = "";
        while ((c = string.charAt(n++)) != '.' && c >= '0' && c <= '9') {
            string3 = String.valueOf(string3) + c;
        }
        if (RAS.isEnabled(19, 2)) {
            RAS.trace(19, 2, this, string2, "DMM version is " + string3);
        }
        return Integer.valueOf(string3);
    }

    public final void initialize() {
        String string = "initialize";
        Serializable serializable = this.mibInfo.getVar("sysOid");
        if (serializable instanceof SpecialValue) {
            this.mibInfo.setErrorCode(1);
            return;
        }
        String string2 = serializable.toString();
        if (RAS.isEnabled(19, 2)) {
            RAS.trace(19, 2, this, string, "Hub SysObjectID -> " + string2);
        }
        this.hubModel = Jdm8260SummaryInfo.modelFromSysOid(string2);
        if (this.hubModel == -1) {
            this.mibInfo.setErrorCode(2);
            return;
        }
        this.refreshMST = this.hubModel == 0;
        if (this.hubModel == 1 && string2.equals("1.3.6.1.4.1.49.2.3.12")) {
            Serializable serializable2 = this.mibInfo.getVar("sysDescr");
            if (serializable2 instanceof SpecialValue) {
                this.mibInfo.setErrorCode(1);
                return;
            }
            String string3 = serializable2.toString();
            this.dmmVersion = this.getDMMVersionFromSysDescr(string3);
            if (this.dmmVersion < 3) {
                this.refreshMST = true;
            }
        }
        this.refresh();
    }

    public final void refresh() {
        this.mibInfo.clearSummaryInfo();
        if (this.refreshMST) {
            this.refreshMst();
            return;
        }
        this.refreshSst();
    }

    private final void refreshMst() {
        String string = "refreshMst";
        try {
            MstDecoder mstDecoder = new MstDecoder();
            mstDecoder.setMibInfo(this.mibInfo);
            GenModel genModel = (GenModel)this.deviceModel.getComponent("MST");
            if (genModel != null) {
                Vector vector = genModel.getRestOfInfo("Panel", "default", null, null);
                Enumeration enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    ModelInfo modelInfo = (ModelInfo)enumeration.nextElement();
                    Serializable serializable = modelInfo.get("Index.ModSummarySlotIndex");
                    Serializable serializable2 = modelInfo.get("Panel.ModSummaryInfo");
                    if (serializable2 instanceof OctetString) {
                        OctetString octetString = (OctetString)serializable2;
                        int n = (Integer)serializable;
                        boolean bl = mstDecoder.decode(octetString.value, n);
                        if (bl) continue;
                        this.mibInfo.setErrorCode(3);
                        if (!RAS.isEnabled(19, 2)) continue;
                        RAS.trace(19, 2, this, string, "Error detected in row -> " + serializable);
                        continue;
                    }
                    this.mibInfo.setErrorCode(4);
                    if (!RAS.isEnabled(19, 2)) continue;
                    RAS.trace(19, 2, this, string, "Probable timeout during summary table retrieve. Received class is -> " + serializable2.getClass().getName());
                }
                vector = null;
                return;
            }
            this.mibInfo.setErrorCode(1);
            return;
        }
        catch (Exception exception) {
            RAS.logException(19, 2, this, string, exception);
            this.mibInfo.setErrorCode(3);
            return;
        }
    }

    private final void refreshSst() {
        String string = "refreshSst";
        try {
            SstDecoder sstDecoder = new SstDecoder();
            sstDecoder.setMibInfo(this.mibInfo);
            GenModel genModel = null;
            genModel = (GenModel)this.deviceModel.getComponent("SST");
            if (genModel != null) {
                Vector vector = genModel.getRestOfInfo("Panel", "default", null, null);
                Enumeration enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    ModelInfo modelInfo = (ModelInfo)enumeration.nextElement();
                    Serializable serializable = modelInfo.get("Index.SsSlotIndex");
                    Serializable serializable2 = modelInfo.get("Index.SsSubSlotIndex");
                    Serializable serializable3 = modelInfo.get("Panel.SsValues");
                    if (serializable3 instanceof OctetString) {
                        int n;
                        OctetString octetString = (OctetString)serializable3;
                        int n2 = (Integer)serializable;
                        boolean bl = sstDecoder.decode(octetString.value, n2, n = ((Integer)serializable2).intValue());
                        if (bl) continue;
                        this.mibInfo.setErrorCode(3);
                        if (!RAS.isEnabled(19, 2)) continue;
                        RAS.trace(19, 2, this, string, "Error detected in row -> " + serializable + "." + serializable2);
                        continue;
                    }
                    this.mibInfo.setErrorCode(4);
                    if (!RAS.isEnabled(19, 2)) continue;
                    RAS.trace(19, 2, this, string, "Probable timeout during summary table retrieve. Received class is -> " + serializable3.getClass().getName());
                }
                vector = null;
                return;
            }
            this.mibInfo.setErrorCode(1);
            return;
        }
        catch (Exception exception) {
            RAS.logException(19, 2, this, string, exception);
            this.mibInfo.setErrorCode(3);
            return;
        }
    }

    static {
        int[] nArray = new int[7];
        nArray[3] = 1;
        nArray[4] = 1;
        nArray[5] = 1;
        nArray[6] = 2;
        modelTranslationTable = nArray;
    }
}

